// Aspect Ratio Demo
//
// version 1 Grahame Marsh 1997
//
// This demo shows how a form can be resized, but the aspect ratio of the
// client area is forced to be the same.  One of the standard splash bitmaps
// is used, this has dimensions of 240 x 180 pixels, so this ratio is put
// into the aspect ratio. The height is modified since the form has a
// top panel as well.

unit AspDemo1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Aspect, ExtCtrls, StdCtrls;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    CheckBox1: TCheckBox;
    Image1: TImage;
    Aspect1: TAspect;
    procedure FormCreate(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
  public
  end;

var
  Form1: TForm1;

// NB if you've not got a "standard" Delphi installation you may need
// to modify this path
const
  TrialBitmapName = 'c:\program files\borland\delphi 2.0\images\splash\256color\chemical.bmp';

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var
  B : TBitmap;
begin
  B := TBitmap.Create;
  try
// get a bitmap
    B.LoadFromFile (TrialBitmapName);
    Image1.Picture.Bitmap := B;

// put the aspect ratio required in the component
    Aspect1.AspectX := B.Width;
    Aspect1.AspectY := B.Height + Panel1.Height;

// set the client size to fix exactly the bitmap full size and the panel
    ClientWidth := B.Width;
    ClientHeight := B.Height + Panel1.Height
  finally
    B.Free
  end
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
var
  R : TRect;
begin
  Aspect1.Active := CheckBox1.Checked;

// switched to active so need to ensure that the aspect ratio is correct
  if Aspect1.Active then
  begin
// get form size into a rect
    R := Rect (Left, Top, Left+Width, Top+Height);

// adjust the right side of the form to keep the ratio ok
    Aspect1.EstablishAspectRatio (saRight, R);

// put it back
    with R do
      SetBounds (Left, Top, Right-Left, Bottom-Top)
  end
end;

// display current bitmap area size
procedure TForm1.FormResize(Sender: TObject);
begin
  Panel1.Caption := IntToStr (ClientWidth) + ', ' +
                    IntToStr (ClientHeight - Panel1.Height) + '    '
end;

end.
